<?php

namespace App\Models;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('blood_type_id', 'city_id', 'date_of_birth', 'name', 'email', 'phone', 'password', 'last_donation_date', 'pin_code');

	public function bloodType()
	{
		return $this->belongsTo('App\Models\BloodType');
	}

	public function cities()
	{
		return $this->belongsTo('App\Models\City');
	}

	public function donationRequests()
	{
		return $this->hasMany('App\Models\DonationRequest');
	}

	public function posts()
	{
		return $this->belongsToMany('App\Models\Post');
	}

	public function governorates()
	{
		return $this->belongsToMany('App\Models\Governorate');
	}

	public function notifications()
	{
		return $this->belongsToMany('App\Models\Notification');
	}

	public function bloodTypes()
	{
		return $this->belongsToMany('App\Models\BloodType');
	}

}