<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePanelsTable extends Migration {

	public function up()
	{
		Schema::create('panels', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->enum('status', array('active', 'completed', 'pending', 'ready', 'onhold'));
			$table->float('k_factor');
			$table->json('geometry_data');
			$table->json('dimensions');
			$table->string('material_type', 255);
			$table->string('panel_type', 255);
			$table->integer('project_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('panels');
	}
}