<?php

namespace App\Models;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('nature', 'account_number', 'tax_number', 'contact_person', 'description', 'user_id');
	protected $visible = array('nature', 'account_number', 'tax_number', 'contact_person', 'description', 'user_id');

	public function users()
	{
		return $this->hasOne('App\Models\User');
	}

	public function events()
	{
		return $this->hasMany('App\Models\Event');
	}

	public function invoices()
	{
		return $this->hasMany('App\Models\Invoice');
	}

}