<?php

namespace App\Models;

class Event extends Eloquent {

	protected $table = 'events';
	public $timestamps = true;
	protected $fillable = array('job_id', 'name', 'description', 'schedule_event_id', 'jobcode_id', 'date_start', 'date_end', 'client_id', 'duration');
	protected $visible = array('job_id', 'name', 'description', 'schedule_event_id', 'jobcode_id', 'date_start', 'date_end', 'client_id', 'duration');

	public function jobs()
	{
		return $this->hasOne('App\Models\Job');
	}

	public function clients()
	{
		return $this->belongsTo('App\Models\Client');
	}

	public function employes()
	{
		return $this->belongsToMany('App\Models\Employe', 'event_employe');
	}

	public function eventEmployes()
	{
		return $this->belongsTo('App\Models\EventEmploye');
	}

}