<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSocialMediaTable extends Migration {

	public function up()
	{
		Schema::create('social_media', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('influencer_id')->unsigned();
			$table->integer('social_media_type_id')->unsigned();
			$table->string('username');
			$table->string('c_key');
			$table->string('c_secret');
			$table->float('post_price');
			$table->integer('followers');
			$table->string('access_token');
			$table->string('access_token_s');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('social_media');
	}
}