<?php

namespace \App\Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Influencer extends Eloquent {

	protected $table = 'influencers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function posts()
	{
		return $this->hasMany('\App\Model\Post');
	}

	public function social_media()
	{
		return $this->hasMany('\App\Model\SocialMedia');
	}

	public function interests()
	{
		return $this->hasMany('\App\Model\Category');
	}

}