<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReturnOrdersTable extends Migration {

	public function up()
	{
		Schema::create('return_orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('order_id')->nullable();
			$table->bigInteger('customer_id')->nullable();
			$table->string('products')->nullable();
			$table->text('reason')->nullable();
			$table->double('amount')->nullable();
			$table->bigInteger('return_status_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('return_orders');
	}
}