<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateElementsTable extends Migration {

	public function up()
	{
		Schema::create('Elements', function(Blueprint $table) {
			$table->increments('idElement');
			$table->integer('idTypeElement')->unsigned()->nullable();
			$table->integer('FontSize')->unsigned()->nullable();
			$table->integer('Top')->unsigned()->nullable();
			$table->integer('Left')->unsigned()->nullable();
			$table->integer('Width')->unsigned()->nullable();
			$table->integer('Height')->unsigned()->nullable();
			$table->string('BackColor')->nullable();
			$table->string('ForeColor')->nullable();
			$table->string('Tag')->nullable();
			$table->string('Ressource')->nullable();
			$table->text('Data')->nullable();
			$table->integer('isPageOffer')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Elements');
	}
}