<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Bundles', function(Blueprint $table) {
			$table->foreign('idLayout')->references('idLayout')->on('Layouts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Bundles', function(Blueprint $table) {
			$table->foreign('idCarrier')->references('idCarrier')->on('Carriers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Elements', function(Blueprint $table) {
			$table->foreign('idTypeElement')->references('idTypeElement')->on('TypeElements')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('BundlePages', function(Blueprint $table) {
			$table->foreign('idBundle')->references('idBundle')->on('Bundles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('BundlePages', function(Blueprint $table) {
			$table->foreign('idPage')->references('idPage')->on('Pages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('PagesElements', function(Blueprint $table) {
			$table->foreign('idPage')->references('idPage')->on('Pages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('PagesElements', function(Blueprint $table) {
			$table->foreign('idElement')->references('idElement')->on('Elements')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Bundles', function(Blueprint $table) {
			$table->dropForeign('Bundles_idLayout_foreign');
		});
		Schema::table('Bundles', function(Blueprint $table) {
			$table->dropForeign('Bundles_idCarrier_foreign');
		});
		Schema::table('Elements', function(Blueprint $table) {
			$table->dropForeign('Elements_idTypeElement_foreign');
		});
		Schema::table('BundlePages', function(Blueprint $table) {
			$table->dropForeign('BundlePages_idBundle_foreign');
		});
		Schema::table('BundlePages', function(Blueprint $table) {
			$table->dropForeign('BundlePages_idPage_foreign');
		});
		Schema::table('PagesElements', function(Blueprint $table) {
			$table->dropForeign('PagesElements_idPage_foreign');
		});
		Schema::table('PagesElements', function(Blueprint $table) {
			$table->dropForeign('PagesElements_idElement_foreign');
		});
	}
}