<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('campaigns', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('campaigns', function(Blueprint $table) {
			$table->foreign('template_id')->references('id')->on('templates')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('templates', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('medias', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('chapters', function(Blueprint $table) {
			$table->foreign('campaign_id')->references('id')->on('campaigns')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('chapters', function(Blueprint $table) {
			$table->foreign('parent_Id')->references('id')->on('chapters')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('researches', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('campaigns', function(Blueprint $table) {
			$table->dropForeign('campaigns_user_id_foreign');
		});
		Schema::table('campaigns', function(Blueprint $table) {
			$table->dropForeign('campaigns_template_id_foreign');
		});
		Schema::table('templates', function(Blueprint $table) {
			$table->dropForeign('templates_user_id_foreign');
		});
		Schema::table('medias', function(Blueprint $table) {
			$table->dropForeign('medias_user_id_foreign');
		});
		Schema::table('chapters', function(Blueprint $table) {
			$table->dropForeign('chapters_campaign_id_foreign');
		});
		Schema::table('chapters', function(Blueprint $table) {
			$table->dropForeign('chapters_parent_Id_foreign');
		});
		Schema::table('researches', function(Blueprint $table) {
			$table->dropForeign('researches_user_id_foreign');
		});
	}
}