<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateChaptersTable extends Migration {

	public function up()
	{
		Schema::create('chapters', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('campaign_id')->unsigned();
			$table->string('title');
			$table->longText('intro');
			$table->integer('order');
			$table->bigInteger('parent_Id')->unsigned()->nullable();
			$table->longText('content');
			$table->longText('shortdescription');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('chapters');
	}
}