<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInventoryTable extends Migration {

	public function up()
	{
		Schema::create('inventory', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('type_id')->unsigned();
			$table->string('locatable_type', 255);
			$table->increments('locatable_id');
			$table->string('titel', 255);
			$table->text('omschrijving');
			$table->boolean('verzekering')->default(0);
			$table->string('code', 31);
			$table->tinyInteger('slotcode');
			$table->string('status', 255);
			$table->datetime('start_facturatie');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('inventory');
	}
}