<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTypesTable extends Migration {

	public function up()
	{
		Schema::create('types', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('type', array(''box'', ''xl-item''));
			$table->string('titel', 255);
			$table->string('slug', 255);
			$table->decimal('prijs');
			$table->decimal('lengte')->nullable();
			$table->decimal('breedte')->nullable();
			$table->decimal('hoogte')->nullable();
			$table->smallInteger('volgorde');
		});
	}

	public function down()
	{
		Schema::drop('types');
	}
}