<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserDetailsTable extends Migration {

	public function up()
	{
		Schema::create('user_details', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('postcode', 6);
			$table->string('telefoonnummer', 31);
			$table->boolean('email_confirmed')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('user_details');
	}
}