<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAppUsersTable extends Migration {

	public function up()
	{
		Schema::create('app_users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255)->nullable();
			$table->string('phone', 255)->nullable();
			$table->string('email', 255)->nullable();
			$table->string('password', 255)->nullable();
			$table->enum('status', array('active', 'pending_activation', 'inactive'))->nullable();
			$table->string('image', 255)->nullable();
			$table->string('activation_code', 5)->nullable();
			$table->integer('resend_code_count')->default('0');
			$table->string('device_token', 255)->nullable();
			$table->string('remember_token', 255)->nullable();
			$table->date('exp_date')->nullable();
			$table->tinyInteger('sex')->nullable();
			$table->string('days_exercise', 255)->nullable();
			$table->date('date_of_birth')->nullable();
			$table->string('weight', 255)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('app_users');
	}
}