<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('app_users_details', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('app_users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('images_devices', function(Blueprint $table) {
			$table->foreign('videos_id')->references('id')->on('videos')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('operations_today', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('app_users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('operations_today', function(Blueprint $table) {
			$table->foreign('today_id')->references('id')->on('today')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('app_users_details', function(Blueprint $table) {
			$table->dropForeign('app_users_details_user_id_foreign');
		});
		Schema::table('images_devices', function(Blueprint $table) {
			$table->dropForeign('images_devices_videos_id_foreign');
		});
		Schema::table('operations_today', function(Blueprint $table) {
			$table->dropForeign('operations_today_user_id_foreign');
		});
		Schema::table('operations_today', function(Blueprint $table) {
			$table->dropForeign('operations_today_today_id_foreign');
		});
	}
}