<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ClientProperty extends Model 
{

    protected $table = 'clientproperties';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('client_id', 'property_name', 'property_details');

    public function client()
    {
        return $this->belongsTo('App\Client', 'client_id');
    }

}