<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressbookTable extends Migration {

	public function up()
	{
		Schema::create('addressbook', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('parent_id')->unsigned();
			$table->string('address1', 255)->nullable();
			$table->string('address2', 255)->nullable();
			$table->string('address3', 255)->nullable();
			$table->string('city', 100)->nullable();
			$table->string('state', 100);
			$table->string('country', 100);
			$table->integer('pincode');
			$table->string('landmark', 100)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('addressbook');
	}
}