<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactsTable extends Migration {

	public function up()
	{
		Schema::create('contacts', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('client_id')->unsigned();
			$table->string('name', 64);
			$table->string('mobile', 10)->nullable();
			$table->string('email', 255)->nullable();
			$table->string('designation', 100)->nullable();
			$table->string('department', 100)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('contacts');
	}
}