<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTypesTable extends Migration {

	public function up()
	{
		Schema::create('types', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('type', array('moods', 'symptoms', 'meditation', 'exercise'));
			$table->string('localization_key', 191);
			$table->string('image', 191);
			$table->integer('limit');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('types');
	}
}