<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateIndicatorsTable extends Migration {

	public function up()
	{
		Schema::create('indicators', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255);
			$table->text('value')->nullable();
			$table->integer('user_id')->nullable();
			$table->integer('hour_of_day')->nullable();
			$table->integer('day_of_week')->nullable();
			$table->integer('month_of_year')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('indicators');
	}
}