<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class LessonParts extends Eloquent {

	protected $table = 'lesson_parts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function lessons()
	{
		return $this->belongsToMany('Lesson', 'lesson_parts_map')->withPivot('order');
	}

	public function type()
	{
		return $this->belongsTo('LessonPartType');
	}

}