<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BillProduct extends Model 
{

    protected $table = 'bill_product';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('bill_id', 'product_id', 'amount', 'price', 'total', 'country_id', 'mall_id');

    public function bill()
    {
        return $this->belongsTo('Bill', 'bill_id');
    }

    public function product()
    {
        return $this->belongsTo('Product', 'product_id');
    }

    public function country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

    public function mall()
    {
        return $this->belongsTo('Mall', 'mall_id');
    }

}