<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Bill extends Eloquent {

	protected $table = 'bill';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('vendor_id', 'issue_date', 'due_date', 'supply_date', 'notes', 'country_id', 'mall_id');

	public function vendor()
	{
		return $this->belongsTo('Vendor', 'vendor_id');
	}

	public function mall()
	{
		return $this->belongsTo('Mall', 'mall_id');
	}

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

}