<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateActivityTable extends Migration {

	public function up()
	{
		Schema::create('activity', function(Blueprint $table) {
			$table->increments('activity_id', true);
			$table->timestamps();
			$table->string('title', 255)->nullable();
			$table->string('description', 255)->nullable();
			$table->string('expectedProductivity', 255)->nullable();
			$table->string('kpi', 255);
			$table->string('measurementUnit', 255);
			$table->string('manHours', 255);
			$table->boolean('status')->default(true);
		});
	}

	public function down()
	{
		Schema::drop('activity');
	}
}