<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('Users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('email');
			$table->string('password');
			$table->enum('rule', array('merchant', 'guide', 'visitor'));
			$table->string('phone_number');
			$table->string('profile_picture');
		});
	}

	public function down()
	{
		Schema::drop('Users');
	}
}