<?php

namespace restx.sellable;

class Sellable extends Eloquent {

	protected $table = 'Sellables';
	public $timestamps = true;

	public function Drink()
	{
		return $this->belongsTo('Drink', 'id');
	}

	public function Food()
	{
		return $this->belongsTo('Food', 'id');
	}

	public function Sellables()
	{
		return $this->morphedByMany('Menu', 'id');
	}

	public function Orders()
	{
		return $this->belongsToMany('Order')->withPivot("OrderSellable");
	}

}