<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBoardsTable extends Migration {

	public function up()
	{
		Schema::create('boards', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name_en');
			$table->string('name_ar');
			$table->string('image');
			$table->string('position_en');
			$table->string('position_ar');
			$table->string('description_en');
			$table->string('description_ar');
			$table->tinyInteger('status')->default('1');
		});
	}

	public function down()
	{
		Schema::drop('boards');
	}
}