<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBlogsTable extends Migration {

	public function up()
	{
		Schema::create('blogs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name_en');
			$table->string('name_ar');
			$table->string('description_ar');
			$table->string('description_en');
			$table->string('image');
			$table->text('content_en');
			$table->text('content_ar');
			$table->tinyInteger('status')->default('1');
			$table->boolean('home')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('blogs');
	}
}