<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAgreementPlanTermsTable extends Migration {

	public function up()
	{
		Schema::create('agreement_plan_terms', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('agreement_id')->unsigned();
			$table->string('title');
			$table->longText('description')->nullable();
			$table->timestamps();
			$table->enum('status', array('inprogress', 'finished', 'cancelled'));
			$table->boolean('is_active')->default(1);
			$table->integer('number_of_stakeholders');
			$table->date('from');
			$table->date('to');
			$table->string('contact_name')->nullable();
			$table->string('contact_phone')->nullable();
			$table->string('contact_email')->nullable();
			$table->bigInteger('department_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('agreement_plan_terms');
	}
}