<?php

namespace App\Models;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;

	public function orders()
	{
		return $this->hasMany('App\Models\Order');
	}

	public function reviews()
	{
		return $this->hasMany('App\Models\Review');
	}

	public function tokens()
	{
		return $this->morphMany('App\Models\Token');
	}

	public function notifactions()
	{
		return $this->morphMany('App\Models\Notifacation');
	}

	public function neighborhood()
	{
		return $this->belongsTo('App\Models\Neighborhood');
	}

}