<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Comment extends Model 
{

    protected $table = 'comments';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('status_id', 'comment_id', 'ticket_id', 'user_id', 'detail');
    protected $visible = array('status_id', 'comment_id', 'ticket_id', 'user_id', 'detail');

    public function comment()
    {
        return $this->belongsTo('Comment');
    }

    public function task()
    {
        return $this->belongsTo('Ticket');
    }

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function replies()
    {
        return $this->belongsTo('Comment');
    }

    public function attachments()
    {
        return $this->morphToMany('Attachment');
    }

}