<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Keyword extends Eloquent {

	protected $table = 'keywords';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function projects()
	{
		return $this->belongsToMany('App\Models\Project', 'project_keyword', 'keyword_id', 'project_id');
	}

}