<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Post extends Eloquent {

	protected $table = 'post';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'content', 'app_id', 'category_id');

	public function app()
	{
		return $this->belongsTo('App', 'app_id');
	}

	public function category()
	{
		return $this->belongsTo('Category', 'category_id');
	}

}