<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGpsJobsTable extends Migration {

	public function up()
	{
		Schema::create('gps_jobs', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('client_id')->unsigned()->index();
			$table->string('chofer', 30)->nullable();
			$table->string('matricula', 20)->nullable();
			$table->integer('gps_id');
			$table->timestamp('delivery_at')->nullable();
			$table->integer('delivered_by')->unsigned()->nullable()->index();
			$table->timestamp('return_at')->nullable();
			$table->integer('return_by')->unsigned()->nullable()->index();
			$table->boolean('complete')->default(0);
			$table->text('notes')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('gps_jobs');
	}
}