<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateImportsTable extends Migration {

	public function up()
	{
		Schema::create('imports', function(Blueprint $table) {
			$table->increments('id');
			$table->boolean('docs')->default(0);
			$table->boolean('docs_out')->default(0);
			$table->string('barco', 20)->nullable();
			$table->enum('despacho', array('T', 'D'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('imports');
	}
}