<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVaciosTable extends Migration {

	public function up()
	{
		Schema::create('vacios', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('client_id')->unsigned()->index();
			$table->enum('tipo', array('Puerto', 'Oficina', 'ZAL'));
			$table->string('matricula', 20);
			$table->string('parking', 10)->nullable();
			$table->text('notes')->nullable();
			$table->boolean('complete')->default(0);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('vacios');
	}
}