<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAstrologerDetailsTable extends Migration {

	public function up()
	{
		Schema::create('astrologer_details', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('astrologer_id')->unsigned();
			$table->string('experience', 255)->nullable();
			$table->longText('description')->nullable();
			$table->string('city')->nullable();
			$table->string('state')->nullable();
			$table->string('bank_name')->nullable();
			$table->string('bank_acc_no')->nullable();
			$table->string('bank_ifsc')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('astrologer_details');
	}
}