<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('user_roles', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('astrologer_details', function(Blueprint $table) {
			$table->foreign('astrologer_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('schedules', function(Blueprint $table) {
			$table->foreign('astrologer_id')->references('user_id')->on('user_roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->foreign('schedule_id')->references('id')->on('schedules')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('user_roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->foreign('astrologer_id')->references('user_id')->on('user_roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('charges', function(Blueprint $table) {
			$table->foreign('astrologer_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_languages', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_languages', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('astrologer_skills', function(Blueprint $table) {
			$table->foreign('astrologer_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('astrologer_skills', function(Blueprint $table) {
			$table->foreign('skill_id')->references('id')->on('skills')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('astrologer_category', function(Blueprint $table) {
			$table->foreign('astrologer_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('astrologer_category', function(Blueprint $table) {
			$table->foreign('category_id')->references('user_id')->on('category')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('astrologer_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->foreign('astrologer_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('user_roles', function(Blueprint $table) {
			$table->dropForeign('user_roles_user_id_foreign');
		});
		Schema::table('astrologer_details', function(Blueprint $table) {
			$table->dropForeign('astrologer_details_astrologer_id_foreign');
		});
		Schema::table('schedules', function(Blueprint $table) {
			$table->dropForeign('schedules_astrologer_id_foreign');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->dropForeign('bookings_schedule_id_foreign');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->dropForeign('bookings_user_id_foreign');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->dropForeign('bookings_astrologer_id_foreign');
		});
		Schema::table('charges', function(Blueprint $table) {
			$table->dropForeign('charges_astrologer_id_foreign');
		});
		Schema::table('user_languages', function(Blueprint $table) {
			$table->dropForeign('user_languages_user_id_foreign');
		});
		Schema::table('user_languages', function(Blueprint $table) {
			$table->dropForeign('user_languages_language_id_foreign');
		});
		Schema::table('astrologer_skills', function(Blueprint $table) {
			$table->dropForeign('astrologer_skills_astrologer_id_foreign');
		});
		Schema::table('astrologer_skills', function(Blueprint $table) {
			$table->dropForeign('astrologer_skills_skill_id_foreign');
		});
		Schema::table('astrologer_category', function(Blueprint $table) {
			$table->dropForeign('astrologer_category_astrologer_id_foreign');
		});
		Schema::table('astrologer_category', function(Blueprint $table) {
			$table->dropForeign('astrologer_category_category_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_user_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_astrologer_id_foreign');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->dropForeign('reports_user_id_foreign');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->dropForeign('reports_astrologer_id_foreign');
		});
	}
}