<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEnveloppeTable extends Migration {

	public function up()
	{
		Schema::create('enveloppe', function(Blueprint $table) {
			$table->increments('id_enveloppe', true);
			$table->integer('id_subvention')->unsigned();
			$table->string('label', 500)->nullable();
			$table->boolean('active')->default(FALSE);
			$table->softDeletes();
			$table->timestamps();
			$table->datetime('date_debut')->nullable();
			$table->datetime('date_fin')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('enveloppe');
	}
}