<?php

namespace App\Models;

class Donation extends Eloquent {

	protected $table = 'donations';
	public $timestamps = true;
	protected $fillable = array('name', 'age', 'bags_num', 'phone', 'hospital_address', 'longitude', 'latitude', 'details', 'client_id', 'blood_type_id', 'city_id');

	public function Donation_Blood_Type()
	{
		return $this->belongsTo('App\Models\BloodType');
	}

	public function City()
	{
		return $this->belongsTo('App\Models\Citiy');
	}

	public function donation_request()
	{
		return $this->belongsToMany('App\Models\Donation');
	}

	public function Client()
	{
		return $this->hasMany('App\Models\Client');
	}

}