<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateModulesTable extends Migration {

	public function up()
	{
		Schema::create('modules', function(Blueprint $table) {
			$table->string('module_id')->unique()->primary();
			$table->string('module_name');
			$table->string('module_description');
			$table->string('module_is_active');
			$table->string('module_duration');
			$table->string('category_id');
			$table->string('application_id');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('modules');
	}
}