<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCheckoutLoginHistoryTable extends Migration {

	public function up()
	{
		Schema::create('checkout_login_history', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('user_id');
			$table->bigInteger('checkout_id');
			$table->enum('type', array('login', 'logout'));
		});
	}

	public function down()
	{
		Schema::drop('checkout_login_history');
	}
}