<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Invoice extends Eloquent {

	protected $table = 'invoices';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('office_associate_id', 'order_id', 'user_id', 'currency', 'receiver_email', 'ettn', 'status', 'pdf', 'send_status', 'print_status');

	public function order()
	{
		return $this->belongsTo('Order');
	}

}