<?php

namespace Forms;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Forms extends Model 
{

    protected $table = 'forms';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('token', 'created_by');

    public function forms()
    {
        return $this->belongsTo('FormsInput', 'form_id');
    }

}