<?php

namespace FormsData;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FormsData extends Model 
{

    protected $table = 'forms_data';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('message_id', 'input_id');

    public function message()
    {
        return $this->belongsTo('FormsMessages', 'form_id');
    }

    public function inputs()
    {
        return $this->belongsTo('FormsInput', 'id');
    }

}