<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('forms_fields', function(Blueprint $table) {
			$table->foreign('form_id')->references('id')->on('forms')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('forms_data', function(Blueprint $table) {
			$table->foreign('message_id')->references('id')->on('forms_message')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('forms_data', function(Blueprint $table) {
			$table->foreign('input_id')->references('id')->on('forms_fields')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('forms_fields', function(Blueprint $table) {
			$table->dropForeign('forms_fields_form_id_foreign');
		});
		Schema::table('forms_data', function(Blueprint $table) {
			$table->dropForeign('forms_data_message_id_foreign');
		});
		Schema::table('forms_data', function(Blueprint $table) {
			$table->dropForeign('forms_data_input_id_foreign');
		});
	}
}