<?php

namespace FormsEmail;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class FormsEmail extends Eloquent {

	protected $table = 'forms_email';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('form_id', 'email_name', 'email_address');
	protected $visible = array('email_name', 'email_address');

	public function Forms()
	{
		return $this->hasOne('Forms', 'id');
	}

}