<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSlotsTable extends Migration {

	public function up()
	{
		Schema::create('slots', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('event_id')->unsigned();
			$table->datetime('date');
			$table->string('location', 255);
			$table->string('authors', 255);
			$table->string('title', 255);
			$table->text('abstract');
			$table->text('comments');
			$table->timestamps();
			$table->integer('user_id')->unsigned()->index();
		});
	}

	public function down()
	{
		Schema::drop('slots');
	}
}