<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderTable extends Migration {

	public function up()
	{
		Schema::create('order', function(Blueprint $table) {
			$table->integer('id', true)->primary();
			$table->string('order_id', 255);
			$table->decimal('order_amount');
			$table->datetime('order_date');
			$table->text('order_status');
			$table->integer('fk_userid')->unsigned();
			$table->text('order_type');
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('order');
	}
}